unit DialogFindRoot;
//=============================================================================
//          .
//           DELPHI
//  (c)  ..  1.1.  25.12.2009.
//=============================================================================
//     INTERFACE
//=============================================================================
interface
uses SysUtils, AnsiTo866, Tools1v2, MyMath1V2;

// ----------------------------------------------------------------------------
//   
procedure EraseRqArray (var RqArray : array of double);
// ----------------------------------------------------------------------------
//    
function InputFloatValue(InvitMsg : string; var Val : double) : byte;
// ----------------------------------------------------------------------------
// .  ,      .
function FindLowX (RqKArray : array of double;
                   RqF0 : double; var Xb : double): byte;
// ----------------------------------------------------------------------------
// .  ,      .
function FindHighX (RqKArray : array of double;
                   RqF0 : double; var Xe : double): byte;
//=============================================================================
//     IMPLEMENTATION
//=============================================================================
implementation

// ----------------------------------------------------------------------------
//   
procedure EraseRqArray (var RqArray : array of double);
var Ind    : integer;  //     
begin
 for Ind := Low(RqArray) to High(RqArray)
 do RqArray[Ind]:= 0;
end;

// ----------------------------------------------------------------------------
//    
function InputFloatValue(InvitMsg : string; var Val : double) : byte;
var WStr  : string;
begin
  Result := 2;                //  -    
  repeat
    WriteRus (InvitMsg);      //     
    ReadLn(WStr);             //    
    if UpCase(WStr[1]) = 'Q'
    then Result := 1          //    (Result := 1;)
    else begin
      //        Result := 0;
      if StrToFloatPro (WStr, Val)
      then Result := 0
      else Val := 0;
    end;
  //         
  until (Result = 0) or (Result = 1);
end;

// ----------------------------------------------------------------------------
//     
procedure WallReport (RqRep : char; WX, WPOL : double);
begin
   Case UpCase(RqRep) of
   'S' : begin
         WriteLnRus ('    OK!    : ' + FloatToStr(WX));
         WriteLnRus ('      X,  = ' + FloatToStr(WPOL));
         WriteLnRus ('       ');
         end;
   else  begin
         WriteLnRus ('    !     = ' + FloatToStr(WX));
         WriteLnRus ('      X,  = ' + FloatToStr(WPOL));
         WriteLnRus ('         Q');
         end
   end;
end;

// ----------------------------------------------------------------------------
// .  ,      .
function FindLowX (RqKArray : array of double;
                   RqF0 : double; var Xb : double): byte;
var WPOL : double;
begin
  WriteLnRus(' ,      ');
  repeat
     Result := InputFloatValue ('    = ', Xb);
     if Result = 0
     then begin
       //    
       WPOL := PPolynom(RqKArray, Xb);
       if WPOL <= RqF0
       then begin
         //     
         Result := 0;                  //   
         WallReport ('S', Xb, WPOL);   //  
       end
       else begin
         //     
         Result := 2;                  //   
         WallReport (' ', Xb, WPOL);    //   
       end;
     end;
  //          
  until (Result = 0) or (Result = 1);
  WriteLn;
end;

// ----------------------------------------------------------------------------
// .  ,      .
function FindHighX (RqKArray : array of double;
                   RqF0 : double; var Xe : double): byte;
var WPOL : double;
begin
  WriteLnRus(' ,      ');
  repeat
     Result := InputFloatValue ('    = ', Xe);
     if Result = 0
     then begin
       //      
       WPOL := PPolynom(RqKArray, Xe);
       if WPOL >= RqF0
       then begin
         //     
         Result := 0;                  //   
         WallReport ('S', Xe, WPOL);   //  
       end
       else begin
         //     
         Result := 2;                  //   
         WallReport (' ', Xe, WPOL);    //   
       end;
     end;
  //          
  until (Result = 0) or (Result = 1);
  WriteLn;
end;

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
end.
